<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="admin-main">
    <!-- Page Header -->
    <div class="admin-card">
        <div class="admin-card-header">
            <h1 class="admin-card-title">
                <i class="bi bi-speedometer2"></i>
                Dashboard Admin
            </h1>
            <div class="d-flex gap-2">
                <a href="<?= base_url('/') ?>" target="_blank" class="admin-btn admin-btn-outline">
                    <i class="bi bi-eye"></i>Lihat Website
                </a>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="admin-alert admin-alert-success">
                <i class="bi bi-check-circle"></i>
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-8">
                <h3 class="text-white mb-3">Selamat Datang, <?= esc(session()->get('username')) ?>!</h3>
                <p class="text-white mb-0">
                    Anda login sebagai <span class="glass-badge glass-badge-primary"><?= esc(str_replace('admin_', '', $userRole)) ?></span>
                </p>
            </div>
            <div class="col-md-4 text-end">
                <div class="admin-stat-icon">
                    <i class="bi bi-person-circle"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="admin-stats-grid">
        <?php if ($userRole === 'admin_activities'): ?>
            <div class="admin-stat-card">
                <div class="admin-stat-icon">
                    <i class="bi bi-calendar-event"></i>
                </div>
                <div class="admin-stat-number"><?= $stats['activities'] ?></div>
                <div class="admin-stat-label">Total Aktivitas</div>
                <div class="mt-3">
                    <a href="<?= base_url('admin/activities') ?>" class="admin-btn admin-btn-primary">
                        <i class="bi bi-arrow-right"></i>Kelola
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($userRole === 'admin_biodata'): ?>
            <div class="admin-stat-card">
                <div class="admin-stat-icon">
                    <i class="bi bi-person"></i>
                </div>
                <div class="admin-stat-number"><?= $stats['biodata'] > 0 ? 'Ada' : 'Belum' ?></div>
                <div class="admin-stat-label">Status Biodata</div>
                <div class="mt-3">
                    <a href="<?= base_url('admin/biodata') ?>" class="admin-btn admin-btn-primary">
                        <i class="bi bi-arrow-right"></i><?= $stats['biodata'] > 0 ? 'Edit' : 'Buat' ?>
                    </a>
                </div>
            </div>
            
            <div class="admin-stat-card">
                <div class="admin-stat-icon">
                    <i class="bi bi-briefcase"></i>
                </div>
                <div class="admin-stat-number"><?= isset($stats['work']) ? $stats['work'] : 0 ?></div>
                <div class="admin-stat-label">Pengalaman Kerja</div>
                <div class="mt-3">
                    <a href="<?= base_url('admin/work') ?>" class="admin-btn admin-btn-primary">
                        <i class="bi bi-arrow-right"></i>Kelola
                    </a>
                </div>
            </div>
            
            <div class="admin-stat-card">
                <div class="admin-stat-icon">
                    <i class="bi bi-folder"></i>
                </div>
                <div class="admin-stat-number"><?= isset($stats['projects']) ? $stats['projects'] : 0 ?></div>
                <div class="admin-stat-label">Proyek</div>
                <div class="mt-3">
                    <a href="<?= base_url('admin/projects') ?>" class="admin-btn admin-btn-primary">
                        <i class="bi bi-arrow-right"></i>Kelola
                    </a>
                </div>
            </div>
            
            <div class="admin-stat-card">
                <div class="admin-stat-icon">
                    <i class="bi bi-award"></i>
                </div>
                <div class="admin-stat-number"><?= isset($stats['certificates']) ? $stats['certificates'] : 0 ?></div>
                <div class="admin-stat-label">Sertifikat</div>
                <div class="mt-3">
                    <a href="<?= base_url('admin/certificates') ?>" class="admin-btn admin-btn-primary">
                        <i class="bi bi-arrow-right"></i>Kelola
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($userRole === 'admin_education'): ?>
            <div class="admin-stat-card">
                <div class="admin-stat-icon">
                    <i class="bi bi-mortarboard"></i>
                </div>
                <div class="admin-stat-number"><?= $stats['education'] ?></div>
                <div class="admin-stat-label">Total Pendidikan</div>
                <div class="mt-3">
                    <a href="<?= base_url('admin/education') ?>" class="admin-btn admin-btn-primary">
                        <i class="bi bi-arrow-right"></i>Kelola
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <!-- Quick Add Card -->
        <div class="admin-stat-card">
            <div class="admin-stat-icon">
                <i class="bi bi-plus-circle"></i>
            </div>
            <div class="admin-stat-number">+</div>
            <div class="admin-stat-label">Tambah Data</div>
            <div class="mt-3">
                <?php if ($userRole === 'admin_activities'): ?>
                    <a href="<?= base_url('admin/activities/create') ?>" class="admin-btn admin-btn-success">
                        <i class="bi bi-plus"></i>Aktivitas
                    </a>
                <?php elseif ($userRole === 'admin_biodata'): ?>
                    <div class="dropdown">
                        <button class="admin-btn admin-btn-success dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="bi bi-plus"></i>Tambah Data
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?= base_url('admin/work/create') ?>">
                                <i class="bi bi-briefcase me-2"></i>Pengalaman Kerja
                            </a></li>
                            <li><a class="dropdown-item" href="<?= base_url('admin/training/create') ?>">
                                <i class="bi bi-book me-2"></i>Pelatihan
                            </a></li>
                            <li><a class="dropdown-item" href="<?= base_url('admin/projects/create') ?>">
                                <i class="bi bi-folder me-2"></i>Proyek
                            </a></li>
                            <li><a class="dropdown-item" href="<?= base_url('admin/certificates/create') ?>">
                                <i class="bi bi-award me-2"></i>Sertifikat
                            </a></li>
                        </ul>
                    </div>
                <?php elseif ($userRole === 'admin_education'): ?>
                    <a href="<?= base_url('admin/education/create') ?>" class="admin-btn admin-btn-success">
                        <i class="bi bi-plus"></i>Pendidikan
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="admin-card">
        <div class="admin-card-header">
            <h2 class="admin-card-title">
                <i class="bi bi-lightning-charge"></i>
                Quick Actions
            </h2>
        </div>

        <div class="row">
            <?php if ($userRole === 'admin_activities'): ?>
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-calendar-plus text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3">Tambah Aktivitas</h5>
                            <a href="<?= base_url('admin/activities/create') ?>" class="admin-btn admin-btn-primary w-100">
                                <i class="bi bi-plus-circle"></i>Buat Baru
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-list-ul text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3">Kelola Aktivitas</h5>
                            <a href="<?= base_url('admin/activities') ?>" class="admin-btn admin-btn-outline w-100">
                                <i class="bi bi-gear"></i>Kelola
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($userRole === 'admin_biodata'): ?>
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-person-plus text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3"><?= $stats['biodata'] > 0 ? 'Edit Biodata' : 'Buat Biodata' ?></h5>
                            <?php if ($stats['biodata'] > 0): ?>
                                <a href="<?= base_url('admin/biodata/edit') ?>" class="admin-btn admin-btn-primary w-100">
                                    <i class="bi bi-pencil"></i>Edit
                                </a>
                            <?php else: ?>
                                <a href="<?= base_url('admin/biodata/create') ?>" class="admin-btn admin-btn-primary w-100">
                                    <i class="bi bi-plus-circle"></i>Buat Baru
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-briefcase-fill text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3">Pengalaman Kerja</h5>
                            <a href="<?= base_url('admin/work') ?>" class="admin-btn admin-btn-primary w-100">
                                <i class="bi bi-gear"></i>Kelola
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-book-fill text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3">Pelatihan</h5>
                            <a href="<?= base_url('admin/training') ?>" class="admin-btn admin-btn-primary w-100">
                                <i class="bi bi-gear"></i>Kelola
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-folder-fill text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3">Proyek</h5>
                            <a href="<?= base_url('admin/projects') ?>" class="admin-btn admin-btn-primary w-100">
                                <i class="bi bi-gear"></i>Kelola
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-award-fill text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3">Sertifikat</h5>
                            <a href="<?= base_url('admin/certificates') ?>" class="admin-btn admin-btn-primary w-100">
                                <i class="bi bi-gear"></i>Kelola
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($userRole === 'admin_education'): ?>
                <div class="col-md-6 col-lg-4 mb-3">
                    <div class="admin-card">
                        <div class="text-center">
                            <i class="bi bi-mortarboard-fill text-admin-primary" style="font-size: 2.5rem;"></i>
                            <h5 class="mt-3 mb-3">Tambah Pendidikan</h5>
                            <a href="<?= base_url('admin/education/create') ?>" class="admin-btn admin-btn-primary w-100">
                                <i class="bi bi-plus-circle"></i>Buat Baru
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-md-6 col-lg-4 mb-3">
                <div class="admin-card">
                    <div class="text-center">
                        <i class="bi bi-globe text-admin-primary" style="font-size: 2.5rem;"></i>
                        <h5 class="mt-3 mb-3">Lihat Website</h5>
                        <a href="<?= base_url('/') ?>" target="_blank" class="admin-btn admin-btn-outline w-100">
                            <i class="bi bi-eye"></i>Buka
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Info -->
    <div class="admin-card">
        <div class="admin-card-header">
            <h2 class="admin-card-title">
                <i class="bi bi-info-circle"></i>
                Informasi Sistem
            </h2>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <h5 class="text-white mb-3">Status Login</h5>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-person-check text-admin-success me-2"></i>
                        Username: <strong><?= esc(session()->get('username')) ?></strong>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-shield-check text-admin-success me-2"></i>
                        Role: <strong><?= esc(str_replace('admin_', '', $userRole)) ?></strong>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-clock text-admin-primary me-2"></i>
                        Login: <strong><?= date('d F Y, H:i') ?></strong>
                    </li>
                </ul>
            </div>
            <div class="col-md-6">
                <h5 class="text-white mb-3">Akses Cepat</h5>
                <div class="d-flex flex-wrap gap-2">
                    <a href="<?= base_url('/') ?>" target="_blank" class="admin-btn admin-btn-outline">
                        <i class="bi bi-house"></i>Home
                    </a>
                    <?php if ($userRole === 'admin_biodata'): ?>
                        <a href="<?= base_url('biodata') ?>" target="_blank" class="admin-btn admin-btn-outline">
                            <i class="bi bi-person"></i>Biodata
                        </a>
                        <a href="<?= base_url('work') ?>" target="_blank" class="admin-btn admin-btn-outline">
                            <i class="bi bi-briefcase"></i>Kerja
                        </a>
                        <a href="<?= base_url('projects') ?>" target="_blank" class="admin-btn admin-btn-outline">
                            <i class="bi bi-folder"></i>Proyek
                        </a>
                        <a href="<?= base_url('certificates') ?>" target="_blank" class="admin-btn admin-btn-outline">
                            <i class="bi bi-award"></i>Sertifikat
                        </a>
                    <?php elseif ($userRole === 'admin_activities'): ?>
                        <a href="<?= base_url('activities') ?>" target="_blank" class="admin-btn admin-btn-outline">
                            <i class="bi bi-calendar"></i>Aktivitas
                        </a>
                    <?php elseif ($userRole === 'admin_education'): ?>
                        <a href="<?= base_url('education') ?>" target="_blank" class="admin-btn admin-btn-outline">
                            <i class="bi bi-mortarboard"></i>Pendidikan
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

